"""
Main FastAPI application cho Batch Testing Tool
"""

import logging

from fastapi import FastAPI
from fastapi.responses import HTMLResponse

from api.routes import router
from config import TOOL_PORT

# Setup logging
logging.basicConfig(
    level=logging.INFO,
    format="%(asctime)s - %(name)s - %(levelname)s - %(message)s",
)

# Create FastAPI app
app = FastAPI(
    title="Batch Testing Tool - Chatbot Canifa",
    description="Tool để test batch chatbot với Excel file",
    version="1.0.0",
)

# Include routes
app.include_router(router)


@app.get("/", response_class=HTMLResponse)
async def root():
    """Serve HTML frontend"""
    try:
        with open("templates/index.html", "r", encoding="utf-8") as f:
            return HTMLResponse(content=f.read())
    except FileNotFoundError:
        return HTMLResponse(
            content="<h1>Error: templates/index.html not found</h1>",
            status_code=500,
        )


if __name__ == "__main__":
    import uvicorn

    uvicorn.run(
        "app:app",
        host="0.0.0.0",
        port=TOOL_PORT,
        reload=True,
        log_level="info",
    )

