# Batch Testing Tool - Chatbot Canifa

Tool để test batch chatbot với file Excel, hỗ trợ test nhiều lần mỗi câu hỏi và thu thập metrics chi tiết.

## 🚀 Tính năng

- ✅ Upload file Excel với danh sách câu hỏi
- ✅ Test mỗi câu hỏi N lần (configurable)
- ✅ Track metrics chi tiết: response, product IDs, latency, cost, tokens
- ✅ Tích hợp Langfuse để lấy metrics (optional)
- ✅ Real-time progress tracking
- ✅ Export Excel với 3 sheets: Summary, Results, Aggregated
- ✅ Beautiful HTML UI

## 📋 Yêu cầu

- Python 3.10+
- Chatbot Canifa API đang chạy
- Langfuse (optional, để lấy thêm metrics)

## 🔧 Cài đặt

1. **Clone và cài đặt dependencies:**
```bash
cd C:\tool_test_chatbot_canifa
pip install -r requirements.txt
```

2. **Cấu hình `.env` file:**
```env
# Chatbot API
CHATBOT_API_URL=http://localhost:8000
CHATBOT_API_ENDPOINT=/api/agent/chat

# Tool settings
TOOL_PORT=5001
MAX_CONCURRENT_REQUESTS=5
REQUEST_TIMEOUT=60

# Langfuse (optional)
LANGFUSE_BASE_URL=https://cloud.langfuse.com
LANGFUSE_SECRET_KEY=your_secret_key_here
```

3. **Chạy server:**
```bash
python app.py
```

4. **Mở browser:**
```
http://localhost:5001
```

## 📝 Cách sử dụng

1. **Chuẩn bị file Excel:**
   - Tạo file Excel với cột chứa câu hỏi (mặc định: "Câu hỏi")
   - Có thể có thêm các cột khác (sẽ được giữ nguyên trong output)

2. **Upload và test:**
   - Mở http://localhost:5001
   - Chọn file Excel
   - Nhập tên cột chứa câu hỏi (mặc định: "Câu hỏi")
   - Chọn số lần test mỗi câu hỏi (1-10)
   - Click "Bắt đầu Test"

3. **Theo dõi progress:**
   - Xem real-time progress bar
   - Xem số lượng đã xử lý, thành công, lỗi

4. **Download kết quả:**
   - Sau khi hoàn thành, click "Download Excel Results"
   - File Excel có 3 sheets:
     - **Summary**: Tổng kết metrics
     - **Results**: Chi tiết từng lần test
     - **Aggregated**: Tổng hợp theo câu hỏi

## 📊 Metrics được track

### Từ API Response:
- AI Response
- Product IDs
- Status (success/error)
- Product count

### Từ Langfuse (nếu enabled):
- Cost (USD)
- Latency (ms)
- Input/Output/Total Tokens
- Model name

### Aggregated Metrics:
- Average cost/latency
- Min/Max latency
- Success rate
- Response consistency (High/Medium/Low)
- Average product count

## 🏗️ Cấu trúc code

```
tool_test_chatbot_canifa/
├── app.py                 # Main FastAPI app
├── config.py              # Config từ .env
├── requirements.txt       # Dependencies
├── api/
│   └── routes.py          # API endpoints
├── services/
│   ├── api_client.py      # Chatbot API client
│   ├── langfuse_client.py  # Langfuse client (optional)
│   └── batch_processor.py # Batch processing logic
├── utils/
│   └── excel_handler.py  # Excel read/write
└── templates/
    └── index.html        # HTML frontend
```

## 🔌 API Endpoints

- `POST /api/batch-test/upload` - Upload Excel và bắt đầu test
- `GET /api/batch-test/progress/{task_id}` - Lấy progress
- `GET /api/batch-test/download/{task_id}` - Download Excel kết quả
- `GET /api/batch-test/health` - Health check

## 📝 Notes

- Tool này gọi API chatbot-canifa, không cần code thay đổi ở chatbot
- Langfuse tự động track trong chatbot, tool chỉ lấy thêm metrics (optional)
- Progress được lưu trong memory, restart server sẽ mất progress
- Trong production, nên dùng Redis hoặc DB để lưu progress

## 🐛 Troubleshooting

1. **Không kết nối được chatbot API:**
   - Kiểm tra `CHATBOT_API_URL` trong `.env`
   - Đảm bảo chatbot server đang chạy

2. **Không đọc được Excel:**
   - Kiểm tra tên cột chứa câu hỏi
   - Đảm bảo file là .xlsx hoặc .xls

3. **Langfuse metrics không có:**
   - Kiểm tra `LANGFUSE_SECRET_KEY` trong `.env`
   - Có thể cần delay để Langfuse sync

