import requests
import json
import time

# Use the DEV endpoint as per user logs
url = "http://localhost:5000/api/agent/chat-dev"
# Token can be anything for dev if middleware allows, or use the valid one
token = "071w198x23ict4hs1i6bl889fit5p3f7"

headers = {
    "Content-Type": "application/json",
    "Authorization": f"Bearer {token}"
}

queries = [
    "tìm cho mình chân váy màu đỏ",
    "tìm quần màu đỏ"
]

print(f"Target URL: {url}")

for query in queries:
    payload = {
        "user_query": query
    }

    print("\n" + "-"*50)
    print(f"Testing Query: '{query}'")
    start = time.time()
    try:
        response = requests.post(url, json=payload, headers=headers, timeout=120)
        duration = time.time() - start
        
        print(f"Status Code: {response.status_code}")
        print(f"Time taken: {duration:.2f}s")
        
        if response.status_code == 200:
            data = response.json()
            # print("Response JSON:", json.dumps(data, indent=2, ensure_ascii=False))
            
            # Extract key info
            ai_response = data.get("ai_response", "")
            user_insight = data.get("user_insight", {})
            product_ids = data.get("product_ids", [])
            
            print(f"🤖 AI Response: {ai_response}")
            print(f"📦 Product IDs: {product_ids}")
            # print(f"🧠 User Insight: {json.dumps(user_insight, ensure_ascii=False)}")
            
        else:
            print("❌ Error Response:")
            print(response.text)

    except Exception as e:
        print(f"❌ Exception: {e}")
