"""
Reset Limit Service - Chỉ dành cho User đã login
Không giới hạn số lần reset (archive chat)
"""
import logging

logger = logging.getLogger(__name__)


class ResetLimitService:
    """
    Service quản lý việc reset (archive) chat.
    Chỉ dành cho user đã đăng nhập, không giới hạn số lần.
    """

    async def check_limit(self, identity_key: str) -> tuple[bool, int, int]:
        """
        Luôn cho phép reset (không giới hạn).
        Returns (can_reset, current_usage, remaining)
        """
        # Không giới hạn - luôn cho phép
        return True, 0, 999

    async def increment(self, identity_key: str):
        """
        Không cần track usage nữa vì không giới hạn.
        """
        pass


reset_limit_service = ResetLimitService()
