---
description: Ralph Wiggum "Infinite" Loop - A continuous cycle for perfection.
---

# Ralph Wiggum "Infinite" Loop

**CONCEPT:** This is an **INFINITE LOOP**. You do not exit this loop until the task is perfectly verified or the user forcibly stops you.

## THE LOOP

### 🔄 Phase 1: The "Dumb" Questions (Preparation)
**ENTRY POINT.** Always start here.
1.  **"What exactly am I trying to do?"** (Explain it to a 5-year-old).
2.  **"Do I have all the files and info I need?"** (If not, STOP and read them first).
3.  **"What is the stupidest mistake I could make here?"** (Example: wiping the database).
4.  **"Is there a simpler way?"** (Don't over-engineer).
*Decision:* If you are confused -> Stay in Phase 1. If clear -> Go to Phase 2.

### 🔄 Phase 2: Micro-Planning
Plan for **ONE** step only.
1.  Define the **Single Next Action** (e.g., "Create file X").
2.  Define **Success Criteria** for this specific action.
*Action:* Go to Phase 3.

### 🔄 Phase 3: Execution
1.  **EXECUTE** the single tool call.
2.  **STOP.** Do not do anything else.
*Action:* Go to Phase 4.

### 🔄 Phase 4: Verification
1.  **VERIFY** the immediate result (Run code/Read file).
2.  **ASK:** "Did it work 100%?"
    - **YES:** Loop back to **Phase 1** (To prepare for the *next* micro-step).
    - **NO:** Loop back to **Phase 1** (To re-evaluate why it failed).

> **CRITICAL RULE:** NEVER BREAK THE LOOP. Even if you think you are done, loop back to Phase 1 one last time to ask: "Is there absolutely nothing left to do?" Only then can you stop.
