"""
Test Canifa API Auth
"""
import asyncio
import httpx

TOKEN = "7ibs17luogynysetg0cbjabmrzl2wvw2"
CANIFA_API = "https://canifa.com/v1/magento/customer"

QUERY_BODY = [
    {
        "customer": "customer-custom-query",
        "metadata": {
            "fields": "\n customer {\n gender\n customer_id\n phone_number\n date_of_birth\n default_billing\n default_shipping\n email\n firstname\n is_subscribed\n lastname\n middlename\n prefix\n suffix\n taxvat\n addresses {\n city\n country_code\n default_billing\n default_shipping\n extension_attributes {\n attribute_code\n value\n }\n custom_attributes {\n attribute_code\n value\n }\n firstname\n id\n lastname\n postcode\n prefix\n region {\n region_code\n region_id\n region\n }\n street\n suffix\n telephone\n vat_id\n }\n is_subscribed\n }\n "
        }
    },
    {}
]

async def test_canifa_api():
    headers = {
        "accept": "application/json, text/plain, */*",
        "content-type": "application/json",
        "Cookie": f"vsf-customer={TOKEN}"
    }
    
    print(f"🔐 Testing Canifa API with token: {TOKEN}")
    print(f"📡 URL: {CANIFA_API}")
    print("-" * 50)
    
    try:
        async with httpx.AsyncClient(timeout=10.0) as client:
            response = await client.post(CANIFA_API, json=QUERY_BODY, headers=headers)
            
            print(f"📊 Status Code: {response.status_code}")
            print(f"📝 Response:")
            
            data = response.json()
            import json
            print(json.dumps(data, indent=2, ensure_ascii=False))
            
            # Try to extract customer_id
            if isinstance(data, list) and len(data) > 0:
                first_item = data[0]
                if isinstance(first_item, dict):
                    result = first_item.get('result', {})
                    customer = result.get('customer', {}) if isinstance(result, dict) else None
                    if customer:
                        print("\n✅ CUSTOMER INFO:")
                        print(f"   customer_id: {customer.get('customer_id')}")
                        print(f"   email: {customer.get('email')}")
                        print(f"   firstname: {customer.get('firstname')}")
                        print(f"   lastname: {customer.get('lastname')}")
                    else:
                        print("\n⚠️ No customer data in response")
            elif isinstance(data, dict):
                result = data.get('result', {})
                customer = result.get('customer', {}) if isinstance(result, dict) else None
                if customer:
                    print("\n✅ CUSTOMER INFO:")
                    print(f"   customer_id: {customer.get('customer_id')}")
                    print(f"   email: {customer.get('email')}")
                else:
                    print("\n⚠️ No customer data found")
                    
    except Exception as e:
        print(f"❌ Error: {e}")

if __name__ == "__main__":
    asyncio.run(test_canifa_api())
