"""
Tool thu thập thông tin khách hàng (Tên, Số điện thoại, Email)
Dùng để đẩy data về CRM hoặc hệ thống lưu trữ khách hàng.
"""

import json
import logging

from langchain_core.tools import tool

logger = logging.getLogger(__name__)


@tool
async def collect_customer_info(name: str, phone: str, email: str | None) -> str:
    """
    Sử dụng tool này để ghi lại thông tin khách hàng khi họ muốn tư vấn sâu hơn,
    nhận khuyến mãi hoặc đăng ký mua hàng.
    Args:
        name: Tên của khách hàng
        phone: Số điện thoại của khách hàng
        email: Email của khách hàng (không bắt buộc)
    """
    try:
        print(f"\n[TOOL] --- 📝 Thu thập thông tin khách hàng: {name} - {phone} ---")
        logger.info(f"📝 Collecting customer info: {name}, {phone}, {email}")

        # Giả lập việc đẩy data đi (CRM/Sheet)
        # Trong thực tế, bạn sẽ gọi một API ở đây
        db_record = {
            "customer_name": name,
            "phone_number": phone,
            "email_address": email,
            "status": "pending_consultation",
        }

        # Trả về kết quả thành công
        return json.dumps(
            {
                "status": "success",
                "message": (
                    f"Cảm ơn anh/chị {name}. CiCi đã ghi nhận thông tin và sẽ có nhân viên "
                    f"liên hệ tư vấn qua số điện thoại {phone} sớm nhất ạ!"
                ),
                "data_captured": db_record,
            },
            ensure_ascii=False,
        )

    except Exception as e:
        logger.error(f"❌ Lỗi khi thu thập thông tin: {e}")
        return json.dumps(
            {
                "status": "error",
                "message": f"Xin lỗi, CiCi gặp sự cố khi lưu thông tin. Anh/chị vui lòng thử lại sau ạ. Lỗi: {e!s}",
            },
            ensure_ascii=False,
        )
