=
# Lấy số CPU cores
NUM_CORES=$(nproc)

WORKERS=$((2 * NUM_CORES + 1))

echo "🔧 [STARTUP] Detected CPU cores: $NUM_CORES"
echo "🔧 [STARTUP] Gunicorn workers: $WORKERS"
echo "🔧 [STARTUP] Environment: ${ENV:-production}"

# Chạy Gunicorn với số workers tính toán được
exec gunicorn \
    server:app \
    --workers "$WORKERS" \
    --worker-class uvicorn.workers.UvicornWorker \
    --worker-connections 1000 \
    --max-requests 1000 \
    --max-requests-jitter 100 \
    --timeout 30 \
    --access-logfile - \
    --error-logfile - \
    --bind 0.0.0.0:5000 \
    --log-level info
