
# API Documentation & UI Feature Updates

## 1. Reset / Archive Chat Feature
The user has requested a function to reset the chat session while preserving the history (archiving it).

### Backend Implementation
- **File:** `api/conservation_route.py`
- **Method:** `POST /api/history/archive`
- **Logic:**
  1. Identify user (via `get_user_identity`).
  2. Call `reset_limit_service.check_limit()` (Max 5 times/day).
  3. Call `manager.archive_history(identity_key)`.
  4. Returns `new_key`, `success` status, and `remaining_resets`.

### Frontend Implementation
- **File:** `static/index.html`
- **UI:** A reset button (🔄) in the chat header.
- **Action:** Calls value API. Displays error if limit exceeded.

## 2. Conversation Manager Updates
- **Logic:** `get_chat_history` has been updated to filter messages by `CURRENT_DATE AT TIME ZONE 'Asia/Ho_Chi_Minh'`.
- **Archiving:** New `archive_history` method renames the `identity_key`.

## 3. Limits
- **Chat Context:** Only the last 15 messages are sent to the LLM (modified in `agent/controller.py`).
- **Reset Limit:** Authenticated users (and guests) are limited to 5 resets per day.
