# Canifa Chatbot API (Simplified)

Base URL: `http://172.16.2.207:5000`

---

## 1. Chat (Gửi tin nhắn)
**POST** `/api/agent/chat`

### Request
#### Guest (Chưa login)
```json
{
  "user_query": "Tìm áo thun nam",
  "device_id": "my-device-123"
}
```

#### User (Đã login)
```json
Headers: Authorization: Bearer <token>
{
  "user_query": "Tìm áo thun nam",
  "device_id": "my-device-123"
}
```


### Response
```json
{
  "status": "success",
  "ai_response": "Shop có mẫu áo thun này...",
  "product_ids": [
    {
      "sku": "8TS24W001",
      "name": "Áo thun nam Basic",
      "price": 250000,
      "sale_price": 199000,
      "url": "https://canifa.com/...",
      "thumbnail_image_url": "https://..."
    }
  ],
  "limit_info": { "limit": 10, "used": 1, "remaining": 9 }
}
```

### Error Response (500)
Trong trường hợp lỗi hệ thống (DB, LLM...), API sẽ trả về HTTP 500 kèm body:
```json
{
  "status": "error",
  "error_code": "SYSTEM_ERROR",
  "message": "Oops 😥 Hiện Canifa-AI chưa thể xử lý yêu cầu của bạn..."
}
```


### Error Response (429) - Rate Limit Exceeded
Khi user/guest vượt quá giới hạn tin nhắn cho phép:

**Trường hợp 1: Guest hết lượt (Cần login)**
```json
{
  "status": "error",
  "error_code": "GUEST_LIMIT_EXCEEDED",
  "message": "Bạn đã sử dụng hết tin nhắn hôm nay. Đăng nhập ngay để dùng tiếp: https://canifa.com/login",
  "require_login": true,
  "limit_info": {
    "limit": 10,
    "used": 10,
    "remaining": 0,
    "reset_seconds": 3600
  }
}
```

**Trường hợp 2: User hết lượt (Hoặc Guest đạt Hard Limit)**
```json
{
  "status": "error",
  "error_code": "USER_LIMIT_EXCEEDED", 
  "message": "Bạn đã sử dụng hết tin nhắn hôm nay. Vui lòng quay lại vào hôm sau để dùng tiếp!",
  "require_login": false,
  "limit_info": { ... }
}
```



---
## 2. History (Lấy lịch sử)
**GET** `/api/history/{your_device_id}?limit=20&before_id=105`

### Query Parameters
| Param | Type | Description |
| :--- | :--- | :--- |
| `limit` | int | Số tin nhắn (Default: 50) |
| `before_id` | int | ID tin nhắn cuối của trang trước (để load thêm) |

### Request
**Guest:**
`/api/history/my-device-123?limit=20`

**User:**
`/api/history/my-device-123?limit=20` (Param URL vẫn giữ là device_id cho tiện FE)  
Header: `Authorization: Bearer <token>`
*(Backend sẽ tự ưu tiên lấy User ID từ Token để truy vấn lịch sử)*

### Response
```json
{
  "data": [
    {
      "id": 105,
      "message": "...", // JSON String
      "is_human": false, 
      "timestamp": "..."
    }
  ],
  "next_cursor": 104 // Dùng ID này cho `before_id` tiếp theo
}
```



---
## 3. Reset (Xóa và tạo mới)
**POST** `/api/history/archive`

### Request
Gửi Header `device_id` (Guest) hoặc `Authorization` (User).
Body rỗng `{}`.

### Response
```json
{
  "status": "success",
  "success": true,
  "message": "Archived successfully",
  "new_key": "my-device-123_archived_..."
}
```
