import requests
import json

url = "http://172.16.2.207:5000/api/agent/chat"

def test_request(name, headers):
    print(f"\n--- TESTING {name} ---")
    payload = {"user_query": "hello test user identify"}
    try:
        res = requests.post(url, json=payload, headers=headers, timeout=10)
        if res.status_code == 200:
            data = res.json()
            limit = data.get('limit_info', {}).get('limit')
            used = data.get('limit_info', {}).get('used')
            print(f"✅ Status: {res.status_code}")
            print(f"ℹ️ Limit: {limit} | Used: {used}")
            print(f"ℹ️ Identity Check: {'Authenticated' if limit == 100 else 'Guest'}") 
        else:
            print(f"❌ Failed: {res.status_code}")
            print(res.text[:100])
    except Exception as e:
        print(f"❌ Error: {e}")

# 1. Guest (Chỉ có Device ID)
test_request("GUEST (Device ID Only)", {
    "Content-Type": "application/json",
    "device-id": "guest-device-final-check"
})

# 2. Authenticated (Token + Device ID)
test_request("AUTHENTICATED (Token)", {
    "Content-Type": "application/json",
    "Authorization": "Bearer 071w198x23ict4hs1i6bl889fit5p3f7",
    "device-id": "guest-device-final-check"
})
