import requests
import json
import sys

url = "http://localhost:5000/api/agent/stream/chat"
headers = {"Content-Type": "application/json"}
data = {
    "query": "Xin chào từ Python script",
    "user_id": "python_test_user"
}

print(f"Sending POST to {url}...")
try:
    with requests.post(url, json=data, headers=headers, stream=True) as r:
        print(f"Status Code: {r.status_code}")
        if r.status_code != 200:
            print(f"Error: {r.text}")
            sys.exit(1)
            
        print("Response Stream:")
        for line in r.iter_lines():
            if line:
                decoded_line = line.decode('utf-8')
                print(decoded_line)
except Exception as e:
    print(f"Exception: {e}")
