# quick_test.py
import time
import pymysql

def quick_test():
    print("🔍 Testing StarRocks connection...")
    print("=" * 50)
    
    print("\n📡 MySQL Connection Latency Test:")
    latencies = []
    for i in range(10):
        start = time.time()
        try:
            conn = pymysql.connect(
                host="172.16.2.100",
                port=9030,
                user="anhvh",
                password="v0WYGeyLRCckXotT",
                database="shared_source",
                connect_timeout=10
            )
            latency = (time.time() - start) * 1000
            latencies.append(latency)
            print(f"  ✅ Attempt {i+1}: {latency:.2f}ms")
            
            # Lần đầu tiên thì check connection limits
            if i == 0:
                cursor = conn.cursor()
                
                cursor.execute("SHOW VARIABLES LIKE 'max_connections'")
                max_conn = cursor.fetchone()
                
                cursor.execute("SHOW STATUS LIKE 'Threads_connected'")
                current = cursor.fetchone()
                
                cursor.execute("SHOW STATUS LIKE 'Max_used_connections'")
                max_used = cursor.fetchone()
                
                print(f"\n🔌 Connection Limits:")
                print(f"  Max Connections:  {max_conn[1] if max_conn else 'N/A'}")
                print(f"  Current Active:   {current[1] if current else 'N/A'}")
                print(f"  Peak Ever Used:   {max_used[1] if max_used else 'N/A'}")
                
                # Tính % usage
                if max_conn and current:
                    usage = (int(current[1]) / int(max_conn[1])) * 100
                    print(f"  Usage:            {usage:.1f}%")
                    if usage > 80:
                        print("  ⚠️  WARNING: Connection pool > 80% full!")
            
            conn.close()
            
        except Exception as e:
            print(f"  ❌ Attempt {i+1} Failed: {e}")
        
        time.sleep(0.3)
    
    if latencies:
        print(f"\n📊 Summary:")
        print(f"  Average:  {sum(latencies)/len(latencies):.2f}ms")
        print(f"  Min:      {min(latencies):.2f}ms")
        print(f"  Max:      {max(latencies):.2f}ms")

if __name__ == "__main__":
    quick_test()