"""
Script tự động thêm context (tên bảng + subsection) vào tất cả size entries trong tonghop.txt
Ví dụ: "Size 92 (2Y):" -> "Size 92 (2Y) - BẢNG SIZE CHUNG CHO UNISEX - TRẺ EM (Dải size lẻ):"
"""

import re


def add_context_to_sizes(input_file, output_file):
    with open(input_file, encoding="utf-8") as f:
        lines = f.readlines()

    result = []
    current_table = None  # Tên bảng hiện tại
    current_subsection = None  # Subsection hiện tại (Dải size lẻ, chẵn...)

    for line in lines:
        stripped = line.strip()

        # Phát hiện header bảng (bắt đầu bằng BẢNG hoặc QUẦN)
        if stripped.startswith("BẢNG SIZE") or stripped.startswith("QUẦN"):
            current_table = stripped
            current_subsection = None  # Reset subsection khi sang bảng mới
            result.append(line)
            continue

        # Phát hiện subsection (Dải size lẻ, Dải size chẵn)
        if "Dải size" in stripped or stripped.startswith("Dải"):
            current_subsection = stripped.rstrip(":")
            result.append(line)
            continue

        # Phát hiện dòng Size (bắt mọi pattern: Size XS:, Size 92 (2Y):, Size 26 (XS):)
        size_match = re.match(r"^(Size\s+[A-Z0-9]+(?:\s*\([^)]+\))?):(.*)$", stripped)
        if size_match and current_table:
            size_part = size_match.group(1)  # "Size 92 (2Y)" hoặc "Size XS"
            rest = size_match.group(2)  # Phần còn lại sau dấu :

            # Xây dựng context
            context_parts = [current_table]
            if current_subsection:
                context_parts.append(f"({current_subsection})")

            context = " - ".join(context_parts)

            # Tạo dòng mới với context
            new_line = f"{size_part} - {context}:{rest}\n"
            result.append(new_line)
            continue

        # Giữ nguyên các dòng khác
        result.append(line)

    # Ghi file output
    with open(output_file, "w", encoding="utf-8") as f:
        f.writelines(result)

    print("✅ Đã thêm context vào tất cả size entries!")
    print(f"📝 File output: {output_file}")


if __name__ == "__main__":
    input_path = r"d:\cnf\chatbot_canifa\backend\datadb\tonghop.txt"
    output_path = r"d:\cnf\chatbot_canifa\backend\datadb\tonghop_with_context.txt"

    add_context_to_sizes(input_path, output_path)

    print("\n🔍 Preview 10 dòng đầu của file mới:")
    with open(output_path, encoding="utf-8") as f:
        for i, line in enumerate(f):
            if i >= 1160 and i < 1170:  # Vùng có size entries
                print(line.rstrip())
