# ============================================================
# 🚀 AUTO PERFORMANCE TEST RUNNER
# ============================================================
# Script tự động:
# 1. Start Mock Server (port 8000)
# 2. Đợi server ready
# 3. Run Locust performance test
# 4. Cleanup
# ============================================================

Write-Host "=" -NoNewline -ForegroundColor Cyan
Write-Host "=" * 59 -ForegroundColor Cyan
Write-Host "🚀 CANIFA CHATBOT - PERFORMANCE TEST AUTOMATION" -ForegroundColor Green
Write-Host "=" -NoNewline -ForegroundColor Cyan
Write-Host "=" * 59 -ForegroundColor Cyan

# Activate venv
Write-Host "`n📦 Activating virtual environment..." -ForegroundColor Yellow
& ..\..\.venv\Scripts\Activate.ps1

# Start Mock Server in background
Write-Host "🎭 Starting Mock Server (Port 8000)..." -ForegroundColor Yellow
$serverJob = Start-Job -ScriptBlock {
    Set-Location "D:\cnf\chatbot_canifa\backend"
    & .venv\Scripts\Activate.ps1
    python locust/api_server_perf.py
}

Write-Host "⏳ Waiting for server to be ready..." -ForegroundColor Yellow
Start-Sleep -Seconds 5

# Check if server is running
try {
    $response = Invoke-WebRequest -Uri "http://localhost:8000/" -UseBasicParsing -TimeoutSec 3
    Write-Host "✅ Mock Server is ready!" -ForegroundColor Green
} catch {
    Write-Host "❌ Mock Server failed to start!" -ForegroundColor Red
    Stop-Job $serverJob
    Remove-Job $serverJob
    exit 1
}

# Run Locust Test
Write-Host "`n🦗 Running Locust Performance Test..." -ForegroundColor Yellow
Write-Host "  - Users: 50" -ForegroundColor Cyan
Write-Host "  - Spawn Rate: 10/s" -ForegroundColor Cyan
Write-Host "  - Duration: 30s" -ForegroundColor Cyan
Write-Host ""

locust -f locust/locustfile_production.py `
    --headless `
    --host http://localhost:8000 `
    -u 50 `
    -r 10 `
    --run-time 30s `
    --html locust/locust_report.html `
    --csv locust/locust_stats

# Cleanup
Write-Host "`n🧹 Stopping Mock Server..." -ForegroundColor Yellow
Stop-Job $serverJob
Remove-Job $serverJob

Write-Host "`n" -NoNewline
Write-Host "=" -NoNewline -ForegroundColor Cyan
Write-Host "=" * 59 -ForegroundColor Cyan
Write-Host "✅ PERFORMANCE TEST COMPLETE!" -ForegroundColor Green
Write-Host "=" -NoNewline -ForegroundColor Cyan
Write-Host "=" * 59 -ForegroundColor Cyan

Write-Host "`n📊 View Results:" -ForegroundColor Yellow
Write-Host "  - HTML Report: locust/locust_report.html" -ForegroundColor Cyan
Write-Host "  - CSV Stats: locust/locust_stats_*.csv" -ForegroundColor Cyan
Write-Host ""
