import asyncio
import os
import sys

# Ensure backend directory is in python path
current_dir = os.path.dirname(os.path.abspath(__file__))
if current_dir not in sys.path:
    sys.path.append(current_dir)

from agent.tools.product_search_helpers import build_starrocks_query

class Params:
    def __init__(self, **kwargs):
        self.__dict__.update(kwargs)

async def main():
    # Params for "tìm cho tao áo side m phù hợp để đi chơi"
    text = "tìm cho tao áo side m phù hợp để đi chơi"
    
    # Mocking what the extraction layer might produce
    params = Params(
        query=text,
        size_scale="M", 
        keywords="áo side m đi chơi"
    )
    
    print(f"Generating query for: {text}")
    
    try:
        sql = await build_starrocks_query(params)
        print("Successfully generated query.")
        print("Check d:\\cnf\\chatbot_canifa\\backend\\embedding.txt")
    except Exception as e:
        print(f"Error: {e}")

if __name__ == "__main__":
    asyncio.run(main())
