import asyncio
import logging
from common.starrocks_connection import StarRocksConnection

# Setup logging
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

async def main():
    try:
        db = StarRocksConnection()
        print("🔌 Connecting to StarRocks...")
        
        # Get Create Table Statement
        table_name = "shared_source.magento_product_dimension_with_text_embedding"
        res = await db.execute_query_async(f"SHOW CREATE TABLE {table_name}")
        
        if res:
            print("\n=== RAW RESULT KEYS ===")
            print(res[0].keys())
            print(res[0])
        else:
            print("❌ Could not get table info.")
            
    except Exception as e:
        print(f"❌ Error: {e}")

if __name__ == "__main__":
    asyncio.run(main())
