import sys
import time
import random

# 1. Giả lập class ConversationManager y hệt như trong code thật
class MockConversationManager:
    def __init__(self):
        # Giả vờ kết nối DB tốn thời gian
        print("   [DB] 🐢 Connecting to Database... (Init)")
        self.connection_id = random.randint(1000, 9999)
        print(f"   [DB] ✅ Connected! ID kết nối: {self.connection_id}")

    def query(self):
        return f"Result from conn {self.connection_id}"

# 2. Biến toàn cục lưu instance (Singleton pattern)
_instance = None

def get_conversation_manager():
    global _instance
    if _instance is None:
        print("   [System] ⚠️ Chưa có instance, đang tạo mới...")
        _instance = MockConversationManager()
    else:
        print("   [System] ♻️ Đã có instance, dùng lại hàng cũ.")
    return _instance

# 3. Giả lập các Request từ User gọi vào Server
print("-" * 50)
print("DEMO: GIẢ LẬP SERVER NHẬN REQUEST LIÊN TỤC")
print("-" * 50)

# Request 1 (User A)
print("\n👉 REQUEST 1: User A vào Chat")
manager1 = get_conversation_manager()
print(f"User A dùng Manager ID: {id(manager1)} (Conn ID: {manager1.connection_id})")

# Request 2 (User B)
print("\n👉 REQUEST 2: User B vào Chat")
manager2 = get_conversation_manager()
print(f"User B dùng Manager ID: {id(manager2)} (Conn ID: {manager2.connection_id})")

# Request 3 (User C)
print("\n👉 REQUEST 3: User C vào Chat")
manager3 = get_conversation_manager()
print(f"User C dùng Manager ID: {id(manager3)} (Conn ID: {manager3.connection_id})")

print("\n" + "-" * 50)
print("KẾT QUẢ KIỂM TRA:")
if manager1 is manager2 is manager3:
    print("✅ THÀNH CÔNG: Cả 3 request đều dùng chung 1 object duy nhất!")
    print("   => Không bị tạo lại kết nối DB thừa thãi.")
else:
    print("❌ THẤT BẠI: Các object khác nhau.")
