"""
Agno Tools - Pure Python functions cho Agno Agent
Đã convert từ LangChain @tool decorator sang Agno format
"""

from .data_retrieval_tool import data_retrieval_tool
from .brand_knowledge_tool import canifa_knowledge_search
from .customer_info_tool import collect_customer_info


def get_agno_tools():
    """
    Get tools cho Agno Agent.
    Agno tự động convert Python functions thành tool definitions.
    
    Returns:
        List of Python functions (Agno tools)
    """
    return [
        data_retrieval_tool,
        canifa_knowledge_search,
        collect_customer_info,
    ]

