import requests
import json
import time

url = "http://localhost:5000/api/agent/chat"
token = "071w198x23ict4hs1i6bl889fit5p3f7"

headers = {
    "Content-Type": "application/json",
    "Authorization": f"Bearer {token}"
}
payload = {
    "user_query": "tư vấn cho mình áo hoodie"
}

print(f"Sending AUTHENTICATED POST request to {url}...")
print(f"Token: {token}")

start = time.time()
try:
    response = requests.post(url, json=payload, headers=headers, timeout=120)
    print(f"Status Code: {response.status_code}")
    print(f"Time taken: {time.time() - start:.2f}s")
    
    if response.status_code == 200:
        data = response.json()
        print("Response JSON:")
        # Print limit info specifically to check if limit increased to USER level (100)
        if "limit_info" in data:
            print("Limit Info:", json.dumps(data["limit_info"], indent=2))
        else:
            print(json.dumps(data, indent=2, ensure_ascii=False))
    else:
        print("Error Response:")
        print(response.text)

except Exception as e:
    print(f"Error: {e}")
