"""Test message limit - Guest limit = 3"""
import requests

DEVICE_ID = "limit-test-002"
API_URL = "http://localhost:5000/api/agent/chat"

print("=" * 50)
print("TEST MESSAGE LIMIT (Guest = 3 tin/ngày)")
print("=" * 50)
print(f"Device ID: {DEVICE_ID}")
print()

for i in range(5):  # Gửi 5 tin để thấy bị chặn
    print(f"--- Tin nhắn #{i+1} ---")
    
    response = requests.post(
        API_URL,
        json={"user_query": f"test message {i+1}"},
        headers={"device_id": DEVICE_ID}
    )
    
    data = response.json()
    
    if data.get("status") == "success":
        limit_info = data.get("limit_info", {})
        print(f"✅ Thành công!")
        print(f"   Used: {limit_info.get('used')}/{limit_info.get('limit')}")
        print(f"   Remaining: {limit_info.get('remaining')}")
    else:
        print(f"❌ Bị chặn!")
        print(f"   Error: {data.get('error_code')}")
        print(f"   Message: {data.get('message')}")
        print(f"   Require login: {data.get('require_login')}")
        limit_info = data.get("limit_info", {})
        if limit_info:
            print(f"   Used: {limit_info.get('used')}/{limit_info.get('limit')}")
    
    print()

print("=" * 50)
print("TEST HOÀN TẤT!")
