"""
Tools Factory
Chỉ return 1 tool duy nhất: data_retrieval_tool
"""

from langchain_core.tools import Tool

from .brand_knowledge_tool import canifa_knowledge_search
from .customer_info_tool import collect_customer_info
from .data_retrieval_tool import data_retrieval_tool
from .promotion_canifa_tool import canifa_get_promotions


def get_retrieval_tools() -> list[Tool]:
    """Các tool chỉ dùng để đọc/truy vấn dữ liệu (Có thể cache)"""
    return [data_retrieval_tool, canifa_knowledge_search, canifa_get_promotions]


def get_collection_tools() -> list[Tool]:
    """Các tool dùng để ghi/thu thập dữ liệu (KHÔNG cache)"""
    return [collect_customer_info]


def get_all_tools() -> list[Tool]:
    """Return toàn bộ list tools cho Agent"""
    return get_retrieval_tools() + get_collection_tools()
