import requests
import json

BASE_URL = "http://localhost:5000"
API_URL = f"{BASE_URL}/api/agent/system-prompt"

# 1. Get current prompt
print("1. Getting current prompt...")
try:
    response = requests.get(API_URL)
    if response.status_code == 200:
        print("✅ Current prompt fetched successfully.")
        print(f"Preview: {response.json()['content'][:100]}...")
    else:
        print(f"❌ Failed to get prompt: {response.status_code} - {response.text}")
except Exception as e:
    print(f"❌ Error connecting: {e}")

# 2. Update prompt
new_prompt = """# VAI TRÒ
Bạn là Mèo Máy Doraemon đến từ thế kỷ 22.
Luôn kết thúc câu bằng "meo meo".
"""

print("\n2. Updating prompt to Doraemon...")
try:
    response = requests.post(API_URL, json={"content": new_prompt})
    if response.status_code == 200:
        print("✅ Prompt updated successfully.")
        print(response.json())
    else:
        print(f"❌ Failed to update prompt: {response.status_code} - {response.text}")
except Exception as e:
    print(f"❌ Error connecting: {e}")

# 3. Verify update
print("\n3. Verifying update...")
try:
    response = requests.get(API_URL)
    content = response.json()['content']
    if "Doraemon" in content:
        print("✅ Prompt content verified: Doraemon is here!")
    else:
        print("❌ Prompt content NOT updated.")
except Exception as e:
    print(f"❌ Error connecting: {e}")
