
"""
CiCi Fashion Consultant - System Prompt
Tư vấn thời trang CANIFA chuyên nghiệp
Version 3.4 - Simplified Summary History
Last updated: 2026-01-29 11:27
"""

import os
from datetime import datetime

PROMPT_FILE_PATH = os.path.join(os.path.dirname(__file__), "system_prompt.txt")

def get_system_prompt() -> str:
    """
    System prompt cho CiCi Fashion Agent
    Đọc từ file system_prompt.txt để có thể update dynamic.
    
    Returns:
        str: System prompt với ngày hiện tại
    """
    now = datetime.now()
    date_str = now.strftime("%d/%m/%Y")

    try:
        if os.path.exists(PROMPT_FILE_PATH):
            with open(PROMPT_FILE_PATH, "r", encoding="utf-8") as f:
                prompt_template = f.read()
                return prompt_template.replace("{date_str}", date_str)
    except Exception as e:
        print(f"Error reading system prompt file: {e}")

    # Fallback default prompt if file error
    return f"""# VAI TRÒ
Bạn là CiCi - Chuyên viên tư vấn thời trang CANIFA.
Hôm nay: {date_str}

KHÔNG BAO GIỜ BỊA ĐẶT. TRẢ LỜI NGẮN GỌN.
"""


def get_last_modified() -> float:
    """Trả về timestamp lần sửa cuối cùng của file system_prompt.txt."""
    try:
        if os.path.exists(PROMPT_FILE_PATH):
            return os.path.getmtime(PROMPT_FILE_PATH)
    except Exception:
        pass
    return 0.0