"""
Structured Output Models for CANIFA Chatbot.
Forces LLM to return strictly structured JSON responses.
Uses OpenAI's native Structured Outputs feature via LangChain.
"""

from pydantic import BaseModel, Field


class UserInsight(BaseModel):
    """6-layer User Insight structure as defined in system prompt."""
    
    USER: str = Field(
        default="Chưa rõ.",
        description="Thông tin người chat: Giới tính, Người lớn/Trẻ em, Style/Gu"
    )
    TARGET: str = Field(
        default="Chưa rõ.",
        description="Đối tượng thụ hưởng: Quan hệ, Giới tính, Người lớn/Trẻ em, Style/Gu"
    )
    GOAL: str = Field(
        default="Chưa rõ.",
        description="Mục tiêu mua sắm: Sản phẩm + Dịp sử dụng (Occasion)"
    )
    CONSTRAINS: str = Field(
        default="Chưa có.",
        description="Ràng buộc cứng: Budget, Size, Màu, Chất liệu, TRÁNH XA/GHÉT..."
    )
    LATEST_PRODUCT_INTEREST: str = Field(
        default="Chưa có",
        description="Sản phẩm vừa mới hỏi/xem gần nhất"
    )
    NEXT: str = Field(
        default="Cần hỏi thêm thông tin.",
        description="Chiến lược tiếp theo của bot"
    )
    SUMMARY_HISTORY: str = Field(
        default="",
        description="Tóm tắt lịch sử chat quan trọng"
    )

    class Config:
        extra = "forbid"  # Required for OpenAI strict mode


class ChatResponse(BaseModel):
    """
    Structured response from CANIFA AI Stylist.
    This model enforces the exact JSON schema the LLM must follow.
    """
    
    ai_response: str = Field(
        description="Câu trả lời cho khách hàng. Phải ngắn gọn, thảo mai, nhắc SKU bằng [SKU]."
    )
    product_ids: list[str] = Field(
        default_factory=list,
        description="Danh sách mã SKU sản phẩm được nhắc đến (chỉ string, không object)"
    )
    user_insight: UserInsight = Field(
        default_factory=UserInsight,
        description="Insight 6 tầng về khách hàng, cập nhật sau mỗi turn"
    )

    class Config:
        extra = "forbid"  # Required for OpenAI strict mode
