import numpy as np
from db.faiss_mgr import FaissManager
from config import INDEX_PATH, MAPPING_PATH

def test_search():
    mgr = FaissManager(dimension=768, index_path=INDEX_PATH, mapping_path=MAPPING_PATH)
    
    if mgr.index.ntotal == 0:
        print("Index is empty!")
        return

    print(f"Index total: {mgr.index.ntotal}")

    # Create a random query vector
    query = np.random.random((768,)).astype('float32')
    norm = np.linalg.norm(query)
    query /= norm

    dist, res = mgr.search(query, top_k=3)
    
    print("Top 3 matches for a random vector:")
    for r in res:
        print(f"SKU: {r['sku']}, Distance: {r['distance']:.4f}")

if __name__ == "__main__":
    test_search()
