"""
KEYWORD MAPPINGS TABLE
══════════════════════

Bảng mapping từ keywords tiếng Việt/Anh → DB field values
Dựa trên data thực tế từ StarRocks

Cấu trúc mỗi entry:
    "keyword": {
        "field": tên cột trong DB,
        "values": list giá trị có thể match,
        "op": "=" hoặc "IN" hoặc "LIKE"
    }
"""

KEYWORD_MAPPINGS = {
    # ═══════════════════════════════════════════════════════════════════════
    # SEASON (Mùa) → field: season
    # DB values: 'Collection', 'Fall Winter', 'Spring Summer', 'Year'
    # ═══════════════════════════════════════════════════════════════════════
    "mùa đông": {"field": "season", "values": ["Fall Winter"], "op": "IN"},
    "thu đông": {"field": "season", "values": ["Fall Winter"], "op": "IN"},
    "mùa hè": {"field": "season", "values": ["Spring Summer"], "op": "IN"},
    "xuân hè": {"field": "season", "values": ["Spring Summer"], "op": "IN"},
    "hè": {"field": "season", "values": ["Spring Summer"], "op": "IN"},
    "đông": {"field": "season", "values": ["Fall Winter"], "op": "IN"},
    "winter": {"field": "season", "values": ["Fall Winter"], "op": "IN"},
    "fall winter": {"field": "season", "values": ["Fall Winter"], "op": "IN"},
    "summer": {"field": "season", "values": ["Spring Summer"], "op": "IN"},
    "spring summer": {"field": "season", "values": ["Spring Summer"], "op": "IN"},
    "cả năm": {"field": "season", "values": ["Year"], "op": "IN"},
    
    # ═══════════════════════════════════════════════════════════════════════
    # GENDER (Giới tính) → field: gender_by_product
    # DB values: 'male', 'female', 'others'
    # ═══════════════════════════════════════════════════════════════════════
    "bé gái": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "bé trai": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "con gái": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "con trai": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "nam giới": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "nữ giới": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "phụ nữ": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "đàn ông": {"field": "gender_by_product", "values": ["male"], "op": "="},
    # Bỏ "nam", "nữ" vì dễ nhầm với "việt nam", "nữ tính", etc.
    # Dùng: "áo nam", "quần nam", "áo nữ", "quần nữ" thay thế
    "áo nam": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "quần nam": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "đồ nam": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "áo nữ": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "quần nữ": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "đồ nữ": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "men": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "women": {"field": "gender_by_product", "values": ["female"], "op": "="},
    "boy": {"field": "gender_by_product", "values": ["male"], "op": "="},
    "girl": {"field": "gender_by_product", "values": ["female"], "op": "="},
    
    # ═══════════════════════════════════════════════════════════════════════
    # AGE (Độ tuổi) → field: age_by_product
    # DB values: 'adult', 'others'
    # ═══════════════════════════════════════════════════════════════════════
    "trẻ em": {"field": "age_by_product", "values": ["others"], "op": "="},
    "em bé": {"field": "age_by_product", "values": ["others"], "op": "="},
    "người lớn": {"field": "age_by_product", "values": ["adult"], "op": "="},
    "bé": {"field": "age_by_product", "values": ["others"], "op": "="},
    "kids": {"field": "age_by_product", "values": ["others"], "op": "="},
    "adult": {"field": "age_by_product", "values": ["adult"], "op": "="},
    
    # ═══════════════════════════════════════════════════════════════════════
    # PRODUCT TYPE (Loại sản phẩm) → field: product_line_vn
    # Dùng LIKE operator vì cần match partial
    # ═══════════════════════════════════════════════════════════════════════
    # Áo các loại
    "áo khoác lông vũ": {"field": "product_line_vn", "values": ["Áo khoác lông vũ"], "op": "LIKE"},
    "áo khoác gió": {"field": "product_line_vn", "values": ["Áo khoác gió"], "op": "LIKE"},
    "áo khoác chần bông": {"field": "product_line_vn", "values": ["Áo khoác chần bông"], "op": "LIKE"},
    "áo khoác chống nắng": {"field": "product_line_vn", "values": ["Áo khoác chống nắng"], "op": "LIKE"},
    "áo khoác nỉ": {"field": "product_line_vn", "values": ["Áo khoác nỉ có mũ", "Áo khoác nỉ không mũ"], "op": "LIKE"},
    "áo khoác dạ": {"field": "product_line_vn", "values": ["Áo khoác dạ"], "op": "LIKE"},
    "áo khoác gilet": {"field": "product_line_vn", "values": ["Áo khoác gilet", "Áo khoác gilet chần bông"], "op": "LIKE"},
    "áo khoác": {"field": "product_line_vn", "values": ["Áo khoác"], "op": "LIKE"},
    "áo phao": {"field": "product_line_vn", "values": ["Áo khoác lông vũ", "Áo khoác chần bông"], "op": "LIKE"},
    "áo len": {"field": "product_line_vn", "values": ["Áo len"], "op": "LIKE"},
    "áo nỉ": {"field": "product_line_vn", "values": ["Áo nỉ", "Áo nỉ có mũ"], "op": "LIKE"},
    "áo thun": {"field": "product_line_vn", "values": ["Áo phông"], "op": "LIKE"},
    "áo phông": {"field": "product_line_vn", "values": ["Áo phông"], "op": "LIKE"},
    "áo sơ mi": {"field": "product_line_vn", "values": ["Áo Sơ mi"], "op": "LIKE"},
    "áo polo": {"field": "product_line_vn", "values": ["Áo Polo"], "op": "LIKE"},
    "áo ba lỗ": {"field": "product_line_vn", "values": ["Áo ba lỗ"], "op": "LIKE"},
    "áo giữ nhiệt": {"field": "product_line_vn", "values": ["Áo giữ nhiệt"], "op": "LIKE"},
    "áo kiểu": {"field": "product_line_vn", "values": ["Áo kiểu"], "op": "LIKE"},
    "áo body": {"field": "product_line_vn", "values": ["Áo Body"], "op": "LIKE"},
    "áo lót": {"field": "product_line_vn", "values": ["Áo lót"], "op": "LIKE"},
    "cardigan": {"field": "product_line_vn", "values": ["Cardigan"], "op": "LIKE"},
    "blazer": {"field": "product_line_vn", "values": ["Blazer"], "op": "LIKE"},
    "hoodie": {"field": "product_line_vn", "values": ["Áo nỉ có mũ", "Áo khoác nỉ có mũ"], "op": "LIKE"},
    "áo": {"field": "product_line_vn", "values": ["Áo"], "op": "LIKE"},
    
    # Quần các loại
    "quần jean": {"field": "product_line_vn", "values": ["Quần jean"], "op": "LIKE"},
    "quần jeans": {"field": "product_line_vn", "values": ["Quần jean"], "op": "LIKE"},
    "quần soóc": {"field": "product_line_vn", "values": ["Quần soóc"], "op": "LIKE"},
    "quần short": {"field": "product_line_vn", "values": ["Quần soóc"], "op": "LIKE"},
    "quần dài": {"field": "product_line_vn", "values": ["Quần dài"], "op": "LIKE"},
    "quần nỉ": {"field": "product_line_vn", "values": ["Quần nỉ"], "op": "LIKE"},
    "quần khaki": {"field": "product_line_vn", "values": ["Quần Khaki"], "op": "LIKE"},
    "quần leggings": {"field": "product_line_vn", "values": ["Quần leggings"], "op": "LIKE"},
    "leggings": {"field": "product_line_vn", "values": ["Quần leggings"], "op": "LIKE"},
    "quần lót": {"field": "product_line_vn", "values": ["Quần lót", "Quần lót đùi", "Quần lót tam giác"], "op": "LIKE"},
    "quần": {"field": "product_line_vn", "values": ["Quần"], "op": "LIKE"},
    
    # Váy/Đầm
    "váy liền": {"field": "product_line_vn", "values": ["Váy liền"], "op": "LIKE"},
    "chân váy": {"field": "product_line_vn", "values": ["Chân váy"], "op": "LIKE"},
    "quần váy": {"field": "product_line_vn", "values": ["Quần váy"], "op": "LIKE"},
    "đầm": {"field": "product_line_vn", "values": ["Váy liền"], "op": "LIKE"},
    "váy": {"field": "product_line_vn", "values": ["Váy"], "op": "LIKE"},
    
    # Đồ bộ
    "bộ mặc nhà": {"field": "product_line_vn", "values": ["Bộ mặc nhà"], "op": "LIKE"},
    "đồ bộ": {"field": "product_line_vn", "values": ["Bộ mặc nhà", "Bộ quần áo"], "op": "LIKE"},
    "pyjama": {"field": "product_line_vn", "values": ["Pyjama", "Bộ mặc nhà"], "op": "LIKE"},
    "đồ ngủ": {"field": "product_line_vn", "values": ["Pyjama", "Bộ mặc nhà"], "op": "LIKE"},
    "bộ thể thao": {"field": "product_line_vn", "values": ["Bộ thể thao"], "op": "LIKE"},
    
    # Phụ kiện
    "tất": {"field": "product_line_vn", "values": ["Tất"], "op": "LIKE"},
    "mũ": {"field": "product_line_vn", "values": ["Mũ"], "op": "LIKE"},
    "khăn": {"field": "product_line_vn", "values": ["Khăn"], "op": "LIKE"},
    "túi xách": {"field": "product_line_vn", "values": ["Túi xách"], "op": "LIKE"},
    "túi": {"field": "product_line_vn", "values": ["Túi xách"], "op": "LIKE"},
    
    # ═══════════════════════════════════════════════════════════════════════
    # STYLE (Phong cách) → field: style
    # DB values: 'Utility', 'Athleisure', 'Feminine', 'Essential', 'Basic', 
    #            'Smart Casual', 'Basic Update', 'Dynamic', 'Trend'
    # ═══════════════════════════════════════════════════════════════════════
    "thể thao": {"field": "style", "values": ["Athleisure", "Dynamic"], "op": "IN"},
    "năng động": {"field": "style", "values": ["Dynamic", "Athleisure"], "op": "IN"},
    "sport": {"field": "style", "values": ["Athleisure"], "op": "IN"},
    "thanh lịch": {"field": "style", "values": ["Feminine", "Smart Casual"], "op": "IN"},
    "nữ tính": {"field": "style", "values": ["Feminine"], "op": "IN"},
    "basic": {"field": "style", "values": ["Basic", "Basic Update"], "op": "IN"},
    "cơ bản": {"field": "style", "values": ["Basic", "Basic Update", "Essential"], "op": "IN"},
    "smart casual": {"field": "style", "values": ["Smart Casual"], "op": "IN"},
    "công sở": {"field": "style", "values": ["Smart Casual"], "op": "IN"},
    "trendy": {"field": "style", "values": ["Trend"], "op": "IN"},
    "thời trang": {"field": "style", "values": ["Trend"], "op": "IN"},
    
    # ═══════════════════════════════════════════════════════════════════════
    # COLOR (Màu sắc) → field: master_color
    # DB values: 'Đen/ Black', 'Trắng/ White', 'Xanh da trời/ Blue', etc.
    # Dùng LIKE vì format phức tạp
    # ═══════════════════════════════════════════════════════════════════════
    "màu đen": {"field": "master_color", "values": ["Đen"], "op": "LIKE"},
    "màu trắng": {"field": "master_color", "values": ["Trắng"], "op": "LIKE"},
    "màu đỏ": {"field": "master_color", "values": ["Đỏ"], "op": "LIKE"},
    "màu xanh": {"field": "master_color", "values": ["Xanh"], "op": "LIKE"},
    "màu hồng": {"field": "master_color", "values": ["Hồng"], "op": "LIKE"},
    "màu vàng": {"field": "master_color", "values": ["Vàng"], "op": "LIKE"},
    "màu nâu": {"field": "master_color", "values": ["Nâu"], "op": "LIKE"},
    "màu xám": {"field": "master_color", "values": ["Xám"], "op": "LIKE"},
    "màu be": {"field": "master_color", "values": ["Be"], "op": "LIKE"},
    "màu cam": {"field": "master_color", "values": ["Cam"], "op": "LIKE"},
    "màu tím": {"field": "master_color", "values": ["Tím"], "op": "LIKE"},
    "đen": {"field": "master_color", "values": ["Đen"], "op": "LIKE"},
    "trắng": {"field": "master_color", "values": ["Trắng"], "op": "LIKE"},
    "đỏ": {"field": "master_color", "values": ["Đỏ"], "op": "LIKE"},
    "xanh": {"field": "master_color", "values": ["Xanh"], "op": "LIKE"},
    "hồng": {"field": "master_color", "values": ["Hồng"], "op": "LIKE"},
    "vàng": {"field": "master_color", "values": ["Vàng"], "op": "LIKE"},
    "nâu": {"field": "master_color", "values": ["Nâu"], "op": "LIKE"},
    "xám": {"field": "master_color", "values": ["Xám"], "op": "LIKE"},
    "be": {"field": "master_color", "values": ["Be"], "op": "LIKE"},
    "cam": {"field": "master_color", "values": ["Cam"], "op": "LIKE"},
    "tím": {"field": "master_color", "values": ["Tím"], "op": "LIKE"},
    
    # ═══════════════════════════════════════════════════════════════════════
    # FORM_SLEEVE (Kiểu tay) → field: form_sleeve
    # DB values: 'Full length Sleeve', 'Short Sleeve', 'Sleeveless', etc.
    # ═══════════════════════════════════════════════════════════════════════
    "dài tay": {"field": "form_sleeve", "values": ["Full length Sleeve"], "op": "IN"},
    "tay dài": {"field": "form_sleeve", "values": ["Full length Sleeve"], "op": "IN"},
    "cộc tay": {"field": "form_sleeve", "values": ["Short Sleeve"], "op": "IN"},
    "tay ngắn": {"field": "form_sleeve", "values": ["Short Sleeve"], "op": "IN"},
    "ngắn tay": {"field": "form_sleeve", "values": ["Short Sleeve"], "op": "IN"},
    "sát nách": {"field": "form_sleeve", "values": ["Sleeveless"], "op": "IN"},
    "không tay": {"field": "form_sleeve", "values": ["Sleeveless"], "op": "IN"},
    
    # ═══════════════════════════════════════════════════════════════════════
    # FITTING (Dáng) → field: fitting
    # DB values: 'Skinny', 'Slim', 'Slimfit', 'Relax', 'Oversize', 'Boxy', 'Regular'
    # ═══════════════════════════════════════════════════════════════════════
    "ôm": {"field": "fitting", "values": ["Skinny", "Slim", "Slimfit"], "op": "IN"},
    "slim": {"field": "fitting", "values": ["Slim", "Slimfit"], "op": "IN"},
    "skinny": {"field": "fitting", "values": ["Skinny"], "op": "IN"},
    "rộng": {"field": "fitting", "values": ["Oversize", "Relax", "Boxy"], "op": "IN"},
    "oversize": {"field": "fitting", "values": ["Oversize"], "op": "IN"},
    "regular": {"field": "fitting", "values": ["Regular"], "op": "IN"},
    "thoải mái": {"field": "fitting", "values": ["Relax", "Regular"], "op": "IN"},
    
    # ═══════════════════════════════════════════════════════════════════════
    # PRODUCT_GROUP (Nhóm sản phẩm) → field: product_group
    # DB values: 'Set', 'Top', 'Outerwear', 'Accessories', 'Dress', 'Bottom', 'Knitwear', 'Underwear'
    # ═══════════════════════════════════════════════════════════════════════
    "đồ lót": {"field": "product_group", "values": ["Underwear"], "op": "IN"},
    "nội y": {"field": "product_group", "values": ["Underwear"], "op": "IN"},
    "phụ kiện": {"field": "product_group", "values": ["Accessories"], "op": "IN"},
    "outerwear": {"field": "product_group", "values": ["Outerwear"], "op": "IN"},
    "knitwear": {"field": "product_group", "values": ["Knitwear"], "op": "IN"},
}
