import random

from locust import HttpUser, between, task

# Danh sách từ khóa để random
PRODUCTS = [
    "áo phông",
    "áo khoác",
    "áo len",
    "áo polo",
    "áo sơ mi",
    "quần jean",
    "quần âu",
    "quần short",
    "váy liền",
    "chân váy",
]
COLORS = ["", "màu đen", "màu trắng", "màu đỏ", "màu xanh", "màu vàng", "màu be"]
GENDERS = ["", "nam", "nữ", "bé trai", "bé gái"]


class FashionUser(HttpUser):
    # Thời gian nghỉ giữa các lần request (mô phỏng người thật: 1-3s)
    wait_time = between(1, 3)

    # --- DB TESTS (ĐÃ TEST XONG, TẠM TẮT) ---
    # @task(3)
    # def search_random_product(self):
    #     """
    #     Giả lập user tìm kiếm sản phẩm bất kỳ.
    #     Ghép random: [Sản phẩm] + [Giới tính] + [Màu]
    #     Ví dụ: "áo phông nam màu đen"
    #     """
    #     # Random query builder
    #     p = random.choice(PRODUCTS)
    #     g = random.choice(GENDERS)
    #     c = random.choice(COLORS)

    #     query = f"{p} {g} {c}".strip()
    #     # Loại bỏ khoảng trắng thừa
    #     query = " ".join(query.split())

    #     self.client.post("/test/db-search", json={"query": query, "limit": 10}, name="/test/db-search (Dynamic)")

    # @task(1)
    # def search_hot_items(self):
    #     """
    #     Giả lập các món Hot trend nhiều người tìm giống nhau (Cache test)
    #     """
    #     hot_item = "áo giữ nhiệt"
    #     self.client.post("/test/db-search", json={"query": hot_item, "limit": 10}, name="/test/db-search (Hero Item)")

    # @task(3)
    # def fast_ping_check(self):
    #     """
    #     Kiểm tra tốc độ thuần túy của việc lấy Connection + SELECT 1.
    #     Nếu cái này < 100ms mà Search > 3000ms --> Do câu Query nặng.
    #     Nếu cái này cũng > 3000ms --> Do Pool bị nghẽn (Server quá tải).
    #     """
    #     self.client.post("/test/db-ping", json={}, name="/test/db-ping (Isolate Latency)")

    # --- LOGIC GRAPH TEST (BẬT) ---
    @task(1)
    def check_graph_overhead(self):
        """
        Test Logic Flow (Mock LLM + MemorySaver).
        ⚠️ Chạy với 300-500 users thôi, không nên quá 1000.
        """
        query = random.choice(["hello", "tìm áo", "giá bao nhiêu", "có màu gì"])
        self.client.post("/test/graph-mock-chat", json={"query": query}, name="/test/graph Logic (Mock LLM)")
