import os

# Model Paths
BASE_DIR = os.path.dirname(os.path.abspath(__file__))
MODELS_DIR = os.path.join(BASE_DIR, "models")

YOLO_MODEL_PATH = os.path.join(MODELS_DIR, "yolow-l_0_05_nms_0_3_v2.onnx")
SIGLIP_MODEL_NAME = "hf-hub:Marqo/marqo-fashionSigLIP"

# FAISS config
INDEX_PATH = os.path.join(MODELS_DIR, "vector_db.index")
MAPPING_PATH = os.path.join(MODELS_DIR, "sku_mapping.pkl")

# Thresholds
DEFAULT_CONFIDENCE_THRESHOLD = 0.5
MARGIN_HIGH_CONFIDENCE = 0.1

# Device
DEVICE = "cpu"
