"""
Script: Check products với data gender bị sai
Tìm các sản phẩm có tên chứa "nữ" nhưng gender_by_product = 'male' (và ngược lại)
"""

import pymysql

conn = pymysql.connect(
    host='172.16.2.100',
    port=9030,
    user='anhvh',
    password='v0WYGeyLRCckXotT',
    database='shared_source',
    cursorclass=pymysql.cursors.DictCursor
)

try:
    with conn.cursor() as cursor:
        # Products tên có "nữ" nhưng gender = 'male'
        print("=" * 80)
        print("PRODUCTS TÊN CÓ 'NỮ' NHƯNG gender = 'male' (DATA SAI!)")
        print("=" * 80)
        
        cursor.execute("""
            SELECT 
                magento_ref_code,
                internal_ref_code,
                product_name,
                gender_by_product,
                product_line_vn
            FROM magento_product_dimension_with_text_embedding
            WHERE gender_by_product = 'male' 
              AND (product_name LIKE '%nữ%' OR product_name LIKE '%Nữ%')
            LIMIT 50
        """)
        
        rows = cursor.fetchall()
        print(f"\nTìm thấy {len(rows)} sản phẩm:\n")
        
        for row in rows:
            print(f"magento_ref_code: {row['magento_ref_code']}")
            print(f"  internal_ref_code: {row['internal_ref_code']}")
            print(f"  product_name: {row['product_name']}")
            print(f"  gender: {row['gender_by_product']} (SAI! Phải là female)")
            print(f"  product_line: {row['product_line_vn']}")
            print()
        
        # Products tên có "nam/trai" nhưng gender = 'female'
        print("\n" + "=" * 80)
        print("PRODUCTS TÊN CÓ 'NAM/TRAI' NHƯNG gender = 'female' (DATA SAI!)")
        print("=" * 80)
        
        cursor.execute("""
            SELECT 
                magento_ref_code,
                internal_ref_code,
                product_name,
                gender_by_product,
                product_line_vn
            FROM magento_product_dimension_with_text_embedding
            WHERE gender_by_product = 'female' 
              AND (product_name LIKE '%nam%' OR product_name LIKE '%trai%' 
                   OR product_name LIKE '%Nam%' OR product_name LIKE '%Trai%')
            LIMIT 50
        """)
        
        rows = cursor.fetchall()
        print(f"\nTìm thấy {len(rows)} sản phẩm:\n")
        
        for row in rows:
            print(f"magento_ref_code: {row['magento_ref_code']}")
            print(f"  internal_ref_code: {row['internal_ref_code']}")
            print(f"  product_name: {row['product_name']}")
            print(f"  gender: {row['gender_by_product']} (có thể sai)")
            print(f"  product_line: {row['product_line_vn']}")
            print()
            
finally:
    conn.close()
